---
Titre : "Journal de bord"
Auteur : "Pierre TIZE MHA"
Date : "16/06/2021"
---

Début d'utilisation : fin de la semaine 2

## Module 3

1. Analyse de données réplicable 

Résultat méthodologique devient ensemble des codes ayant permis de faire les calculs accompagnés d'une explication détaillée

2. Etude de cas : incidence des syndromes grippaux 

Format date selon la norme ISO 8601 des date : l'année commence par la 1ere semaine qui contient le 4 janvier ou celle qui a plus de la moitié des ces jours dans l'année en cours.

Ne jamais faire des modications de données à la main : plutôt avec du code.

3. Importer les données avec Rstudio / R 
 
environnement RStudio ; langage R ; bibliothèque parsedate pour la gestion des 
dates en format iso  

Important de lire les données directement de la source et faire attention aux données manquantes.

Pour charger un document d'un site web : insérer un chunk R dans le document markdown l'adresse 
Dans le chunk data_url = "lien url" 
Si première ligne à ignorer : écrire 'data = read.csv(data_url, skip=1)'

Pour voir les premières lignes de données : 'head(data)' 
Pour voir les dernière lignes de données : 'tail(data)'

Recherche de données manquantes 'données_manquantes = apply(data, 1, function(x) any(is.na(x)))'
Le "1" fait passer la commande ligne par ligne et la fonction fait la recherche de données manquantes colonne par colonne.

Pour inspecter le type de données : 'class(data$variable)';
Ceci donne : interger (Nb entier); factor (V. qualitative); 

Pour transformer une donnée comme "-" ou "?" en valeur manquante, il faut relire les données en spécifiant les valeur à lire comme valeur manquante :
'data = read.csv(data_url, skip=1, na.string = "-"'

4. Vérification et inspection des données  

date au format iso dans la librairie parsedate ;

Exple : 'date = 199501'
        conversion en chaine de caractères : 'ws = paste(date)'
        attribution année et semaines : 'iso = paste0(substring(ws, 1, 4) "-W", substring(ws, 5 ,6)'
        Le résultat : "1995-W01" correspondant semainte 7 de l'année 1982
        Ensuite faire appel à la fonction **parse_iso8601** soit parse_iso_8601(iso) 
        Ceci donne : "1995-01-02 UTC" soit la date du lundi de cette semaine.
        
        On transforme tout ce qui précède pour l'appliquer à une variable.
        'convert_week = fonction(date) {
            ws = paste(date)
            iso = paste0(substring(ws, 1, 4), "-W", sobstring(ws, 5, 6))
            parse_iso_8601(iso)
        }'
        Résultat à coller dans une nouvelle variable : sapply(data$week, convert_week)
        Malheureusement 'sapply' va donner des nombres entiers dans la base.
        Convertir alors la ligne parse_iso_8601 en chaine de caractère : 'as.character(parse_iso_9601(iso))
        Puis en date : 'data$date = as.Date (sapply(data$week, convert_week))'

Deuxième étape : classer les données par ordre chronologique : 'data = data[order(data$date),]'
    
    Vérifier si distance entre 2 dates voisines = 1 semaine : 'all(diff(data$date)) == 7'
    
    appliquer un plot : 'with(data, plot(V1, V2, type="l"))'
    Si trop serré, refaitre sur les 200 dernières lignes : 'with(tail(data, 200), plot(V1, V2, type="l"))'

A la fin vérifier les données par l'inspection visuelle (plot par exple) et des code de validation (vérifier distance entre deux semaines par exple).

5. Exercice 

## Module 4 

1. L'enfer des données

Deux formats binaires pour stocker les données avec les métadonnées : FITS (plus complexe et plus flexible) et HDFR
Archivage : zenodo et figshare pour archivage pérenne et accessible à tous

2. L'enfer du logiciel 

- passage à l'chelle : les codes complexes

Rentrer les données dans un workflow permettant de mieux structurer le documents.
Le moteur d'exécution du workflow permet l'exécution des commandes dans l'ordre cotrairement au notebook.
Cependant pas de description dans le workflow.
exple : Pegasus, collective knowledge, galaxy 
autres léger (dask, swift, drake ...) et autres hybrides prototypes entre notebook et workflow.

Faire de checkpoint pour les calculs trop longs qui deviennent rapidement interminables.

- passage à l'chelle : les envrionnements complexes

Conserver le bazar : capture automatique de l'environnement avec CDE, ReproZip, CARE ; le résultat ne peut être modiefier
Faire le ménage : partir d'un environnement vierge et installer uniquement le nécessaire ; plusieurs solutions : Docker/singularity, Guix/Nix

- l'épreuve du temps 

Les mises à jour des logiciels de l'environnement interne ou externe (linux, windows) d'utilsation peut modifier les résultats.

Software Heritage : hébergement de tous les logiciels du monde 
HAL : autre solution d'archivage 

3. l'enfer du calcul 

Les compilateur peuvent inverser l'ordres des opération
Deux options pour un calcul reproductible : insister sur le respect de l'ordre des opération ou rendre la compilation reproductible (noter toutes les options et version du compilateur)

Calcul parallèle : les calculs sont repartis sur différents processeurs d'où un risque de non reproductibilité

        calcul = plateforme + logiciel + données 
        
Les nombres aléatoires sont en réalité pseudo-aléatoires avec les logiciels car basé sur une logique (comme l'heure).
Avec un générateur de nombre aléatoire : reproduire la graine dans le code de l'application et vérifier les trois prémiers nombres générés.