# Projet de Techniques numériques pour l’Optique 

## Simulation d’un faisceau de Bessel

### __Définition__
Un faisceau de Bessel est *un champ de rayonnement électromagnétique*, 
**acoustique** ou même **gravitationnel** dont l’amplitude est décrite par une fonction 
de Bessel de premier type. Un vrai faisceau de Bessel est **non** **diffractif**.(https://fr.wikipedia.org/wiki/Faisceau_de_Bessel)
### Etape: 
- Dans un premier temps nous allons créer des simulacres de faisceaux en 
python (BPM) en effectuant la concentration d’un faisceau gaussien avec 
des lentilles axicons pour générer des faisceaux de Bessel-Gauss
- Nous allons ensuite simuler par la BPM, la propagation de ces faisceaux 
sur une courte distance pour vérifier la non diffraction et les bloquer 
partiellement pour qu’ils puissent se reconstituer plus loin sur l’axe du 
faisceau.
- Puis nous montrerons qu’un faisceau de Bessel maintient sa concentration 
sur une relative longue section du faisceau et ceux même s’il est en partie 
masqué par les particules (cas des pinces optiques).
- Nous tenterons de simuler la propagation de faisceau de Bessel dans une 
fibre optique (à cœur et gaine concentriques) en y relevant les modes de 
vibrations, et interpréter les phénomènes de diffractions observables. Et 
montrer ainsi l’intérêt du faisceau non diffractant de Bessel dans de tel 
dispositif.

![ Coupe schématique d'un faisceau de Bessel et graphique de son intensité. ](https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/Bessek_beam_intensity.svg/330px-Bessek_beam_intensity.svg.png)
! [Evolution d'un faisceau de Bessel](https://upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Bessel_beam.gif/330px-Bessel_beam.gif)
<!-- Nous pourrons utiliser OSLO au besoin pour la dernière partie 
comme autre outil de simulation et comparer si possible les résultats -->
### PLAN 

1. Etude physique: Equations de Bessel
2. Etude numérique: Code
3. Simulation: animation graphique

