In this project, we gather reproduction attempts from the Challenger
study. In particular, we try to reperform some of the analysis provided
in *Risk Analysis of the Space Shuttle: Pre-Challenger Prediction of
Failure* by *Siddhartha R. Dalal, Edward B. Fowlkes, Bruce Hoadley*
published in *Journal of the American Statistical Association*, Vol. 84,
No. 408 (Dec., 1989), pp. 945-957 and available at
[here](https://studies2.hec.fr/jahia/webdav/site/hec/shared/sites/czellarv/acces_anonyme/OringJASA_1989.pdf)
(here is [the official JASA
webpage](http://www.jstor.org/stable/2290069)).

On the fourth page of this article, they indicate that the maximum
likelihood estimates of the logistic regression using only temperature
are: $`\hat{\alpha}=5.085`$ and $`\hat{\beta}=-0.1156`$ and their
asymptotic standard errors are $`s_{\hat{\alpha}}=3.052`$ and
$`s_{\hat{\beta}}=0.047`$. The Goodness of fit indicated for this model
was $`G^{2} = 18.086`$ with 21 degrees of freedom. Our goal is to
reproduce the computation behind these values and the Figure 4 of this
article, possibly in a nicer looking way.


[*Here is our successful replication of Dalal et al. results using
R*](challenger.pdf).

1.  Try to **replicate the computation** from Dalal et al. In case it
    helps, we provide you with twoimplementations of this case study
    but we encourage you to **reimplement them by yourself** using both
    your favourite language and an other language you do not know yet.
    -   A [Jupyter Python3 notebook](src/Python3/challenger.ipynb)
    -   An [Rmarkdown document](src/R/challenger.Rmd)
2.  Then **update the following table with your own results by
    indicating in each column:**
	-   Language: R, Python3, Julia, Perl, C...
	-   Language version:
	-   Main libraries: please indicate the versions of all the loaded
		libraries
    -   Tool: Jupyter, Rstudio, Emacs
	-   Operating System: Linux, Mac OS X, Windows, Android, ... along with
      its version
	-   $`\hat{\alpha}`$ and $`\hat{\beta}`$: Identical, Similar, Different,
Non functional (expected values are $`5.085`$ and $`-0.1156`$)
	-   $`s_{\hat{\alpha}}`$ and $`s_{\hat{\beta}}`$: Identical, Similar,
			Different, Non functional (expected values are $`3.052`$ and $`0.047`$)
	-   $`G^2`$ and degree of freedom: Identical, Similar, Different, Non
		functional (expected values are $`18.086`$ and $`21`$).
	-   Figure: Similar, Different, Non functional, Did not succeed
	-   Confidence region: Identical (to [the one obtained with R](challenger.pdf)), Similar, Quite Different, Did not succeed
 
| Language | Language version | Main libraries                                                | Tool    | Operating System               | $`\hat{\alpha}= 5.085`$ $`\hat{\beta} = -0.1156`$ | $`s_{\hat{\alpha}} = 3.052`$ $`s_{\hat{\beta}} = 0.047`$ | $`G^{2} = 18.086`$ $`dof = 21`$ | Figure    | Confidence Region | Link to the document                                                                                                                                                                                                                                                                                                         | Author      |
| -------- | ---------------- | ------------------------------------------------------------- | ------- | ----------------------------   | -------------                            | ----------                                | ----------                   | --------- | ----------   | -----------------------------------------------------------------                                                                                                                                                                                                                                                                                            | ----------- |
| R        |            3.5.1 | ggplot2 3.0.0                                                 | RStudio | Debian GNU/Linux buster/sid    | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](src/R/challenger.Rmd), [pdf](src/R/challenger_debian_alegrand.pdf)                                                                                                                                                                                                                                                                                     | A. Legrand  |
| Python   |            3.6.4 | statsmodels 0.9.0 numpy 1.13.3 pandas 0.22.0 matplotlib 2.2.2 | Jupyter | Linux Ubuntu 4.4.0-116-generic | Identical                                | Identical                                 | Identical                    | Identical | Similar      | [ipynb](src/Python3/challenger.ipynb), [pdf](src/Python3/challenger_ubuntuMOOC_alegrand.pdf)                                                                                                                                                                                                                                                                 | A. Legrand  |
| R        |            3.5.1 | ggplot2 3.0.0                                                 | RSrudio | Windows >= 8 x64 (build 9200)  | Identical                                | Identical                                 | Identical                    | Identical | Similar      | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/8517fa92e97b3a318e653caefbfde6b5/mooc-rr/blob/master/module4/MOOC_exercice_module4.Rmd), [Pdf](https://app-learninglab.inria.fr/moocrr/gitlab/8517fa92e97b3a318e653caefbfde6b5/mooc-rr/blob/master/module4/MOOC_exercice_module4.pdf)                                                                   | M. Saubin   |
| Python   |            3.6.4 | pandas 0.22.0, matplotlib 2.2.3, numpy 1.15.2, seaborn 0.8.1  | JNot    | Linux 146~16.04.1-Ubuntu       | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [ipynb](https://app-learninglab.inria.fr/moocrr/jupyter/user/39231d25304f71162fa7ae71b0273be0/notebooks/work/module4/py_challenger_rexcecution.ipynb)                                                                                                                                                                                                        | 39231d25304f71162fa7ae71b0273be0 |
| Python   |            3.9.5 | statsmodels 0.13.2 numpy 1.21.4 pandas 1.2.4 matplotlib 3.4.2 | Jupyter | Ubuntu 21.04                   | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/1d334d5105a1a432e18f2e361780bab5/mooc-rr/blob/master/module4/challenger.pdf)                                                                                                                                                                                                                            |1d334d5105a1a432e18f2e361780bab5|
| Python   |            3.6.4 | statsmodels 0.9.0 numpy 1.15.2 pandas 0.22.0 matplotlib 2.2.3 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical                                | Identical                                 | Identical                    | Identical | Similar      | [ipynb](module4/challenger_Python_ipynb.ipynb), [pdf](module4/challenger_Python_ipynb.pdf)                                                                                                                                                                                                                                                                   |2992438755465b7fe3afd7856bde0599|
| R        |            3.4.4 | ggplot2_3.3.0                                                 | RStudio | Linux Mint 19                  | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/b2c48a7ab4afbff5f4d26650b09eb6b4/mooc-rr/blob/master/module4/challenger_reexecuted.Rmd), [html](https://app-learninglab.inria.fr/moocrr/gitlab/b2c48a7ab4afbff5f4d26650b09eb6b4/mooc-rr/blob/master/module4/challenger_reexecuted.html)                                                                 | b2c48a7ab4afbff5f4d26650b09eb6b4 |
| Python   |            3.6.4 | statsmodels 0.9.0 numpy 1.15.2 pandas 0.22.0 matplotlib 2.2.3 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical                                | Identical                                 | Identical                    | Identical | Similar      | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/34ea1ee296fc8711adf020d9cc2cb571/mooc-rr/blob/master/module4/challenger.ipynb), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/34ea1ee296fc8711adf020d9cc2cb571/mooc-rr/blob/master/module4/challenger.pdf)                                                                                     | 34ea1ee296fc8711adf020d9cc2cb571 |
| Matlab   | 9.6.0.1072779 (R2019a) |                                              | Matlab Live Script | Windows 10.0.18362             | Identical                                | Identical                                 | Non Functionnal              | Similar   | Did not succeed | [mlx](https://app-learninglab.inria.fr/moocrr/gitlab/34ea1ee296fc8711adf020d9cc2cb571/mooc-rr/blob/master/module4/challenger.mlx), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/34ea1ee296fc8711adf020d9cc2cb571/mooc-rr/blob/master/module4/challenger_matlab.pdf)                                                                               | 34ea1ee296fc8711adf020d9cc2cb571 |
| R        |            3.6.1 | ggplot2 3.1.1  | RSrudio | Ubuntu 18.04.4 LTS             | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/a308dc99373eb1db581156a44d010769/mooc-rr/blob/master/module4/challenger_aschmide.Rmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/a308dc99373eb1db581156a44d010769/mooc-rr/blob/master/module4/challenger_aschmide.pdf)                                                                       | a308dc99373eb1db581156a44d010769 |
| R        |            3.5.3 | ggplot2_3.1.1                                                 | RStudio | Windows 10 x64 (build 18363)   | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/84848da3cce8d6b635b2e7c1749f3f0a/mooc-rr/blob/master/module4/challenger_CL.Rmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/84848da3cce8d6b635b2e7c1749f3f0a/mooc-rr/blob/master/module4/challenger_CL.pdf)                                                                                   | 84848da3cce8d6b635b2e7c1749f3f0a |
| Python   |            3.7.6 | statsmodel 0.11.1 scipy 1.4.1 pandas 1.0.3 seaborn 0.10.0     | Jupyter | Ubuntu 18.04.4 LTS             | Identical                                | Identitcal                                | Identical                    | Non functionnal | Non functionnal | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/a308dc99373eb1db581156a44d010769/mooc-rr/blob/master/module4/challenger.ipynb) [html]                                                                                                                                                                                                        | a308dc99373eb1db581156a44d010769 |
| Python   |            3.7.4 | statsmodel 0.10.1 scipy 1.3.1 pandas 0.25.1 seaborn 0.9.0     | Jupyter | Windows 10 x64                 | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/e33eb88ad13e77fcab40e23aa5b9eb7e/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb))                                                                                     | e33eb88ad13e77fcab40e23aa5b9eb7e |
| Julia    |            1.4.0 | CSV v0.6.1 DataFrames v0.20.2 GLM v1.3.9                     | Weave.jl | Linux Debian 4.14.17-1 x86_64  | Identical                                | Identical                                 | Similar                      | Identical | Did not succeed | [jmd](https://app-learninglab.inria.fr/moocrr/gitlab/3e6bf7b47a05a05ae3d6af86121dcb5d/mooc-rr/blob/master/module4/challenger.jmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/3e6bf7b47a05a05ae3d6af86121dcb5d/mooc-rr/blob/master/module4/challenger.pdf), [html](https://app-learninglab.inria.fr/moocrr/gitlab/3e6bf7b47a05a05ae3d6af86121dcb5d/mooc-rr/blob/master/module4/challenger.html) | 3e6bf7b47a05a05ae3d6af86121dcb5d |
| R        |            3.6.3 | ggplot2 3.3.0                                                 | RStudio | Windows 10 x64 (build 18363)   | Similar $`\hat{\alpha}=5.08498`$ $`\hat{\beta}=-0.11560`$ | Similar $`s_{\hat{\alpha}} = 3.05247`$ $`s_{\hat{\beta}} = 0.04702`$ | Identical | Identical | Identical | [Rmd] (https://app-learninglab.inria.fr/moocrr/gitlab/d581efc242e1e06dfa8d0dea8ee470e0/mooc-rr/blob/master/module4/Exo1_Module4.Rmd), [pdf] (https://app-learninglab.inria.fr/moocrr/gitlab/d581efc242e1e06dfa8d0dea8ee470e0/mooc-rr/blob/master/module4/Exo1_Module4.pdf) | d581efc242e1e06dfa8d0dea8ee470e0 |
| Python   |            3.7.7 | statsmodel 0.11.1 scipy 1.4.1 pandas 1.0.3 seaborn 0.10.0     | Jupyter | Linux Mint 19.1 Cinnamon       | Identical                                | Identitcal                                | Identical                    | Similar   | Similar       | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/1affb6a270b94ae1aa2914210661b070/mooc-rr/blob/master/module4/exo/challenger.ipynb) [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/1affb6a270b94ae1aa2914210661b070/mooc-rr/blob/master/module4/exo/challenger.pdf)                                                                             | 1affb6a270b94ae1aa2914210661b070 |
| Python   |            3.6.4 | statsmodels 0.9.0 numpy 1.15.2 pandas 0.22.0 matplotlib 2.2.3 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [ipynb] (https://app-learninglab.inria.fr/moocrr/gitlab/d3ffe1dda057aedb6d37daa14d4dce86/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb), [pdf] (https://app-learninglab.inria.fr/moocrr/gitlab/d3ffe1dda057aedb6d37daa14d4dce86/mooc-rr/blob/master/module4/src_Python3_challenger.pdf) |  d3ffe1dda057aedb6d37daa14d4dce86 | 
| R        |            3.6.3 | ggplot2 3.3.0                                                 | RStudio | Windows 10 x64 (build 18363)   | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd] (https://app-learninglab.inria.fr/moocrr/gitlab/3e3d09557efde0d973c3f246d977cc35/mooc-rr/blob/master/module4/Gullstrand_src_R_challenger.Rmd)| https:// 3e3d09557efde0d973c3f246d977cc35 |
| R        |            3.5.1 | ggplot2 3.3.0                                                 | RStudio | Windows 10 x64 (build 18363)   | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/525f77b1f86b1bcc7fc77168921eb737/mooc-rr/blob/master/challenger.Rmd) [html](https://app-learninglab.inria.fr/moocrr/gitlab/525f77b1f86b1bcc7fc77168921eb737/mooc-rr/blob/master/challenger.html) |
| Python   |            3.7.1 | statsmodels 0.10.1 scipy 1.1.0 pandas 0.25.3 seaborn 0.9.0    | Jupyter | Windows 10 x64 (build 17134)   | Similar $`\hat{\alpha}=5.0850'$          | Identical                                 | Identical                    | Identical after code change | Identical after code change | [ipynb] (https://app-learninglab.inria.fr/moocrr/gitlab/65f0b71b8c107dc7c99fe00b869170e1/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb), | 65f0b71b8c107dc7c99fe00b869170e1 |
| Python   |            3.6.4 | statsmodels 0.9.0 scipy 1.1.0 pandas 0.22.0 seaborn 0.8.1     | Jupyter | Windows 10 x64 (build 18363)   | Identical   
| R        |            3.5.1 | ggplot2_3.1.0                                                 | RStudio | Windows 10 Pro 1909 - 64 bits  | Similar (5.08498 , -0.1156)              | Similar ( ,3.052 ,0.04702 )               |  Identical                   |Identical  | Identical    |      [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/de98852947736bd9e2f70971a6ed56d0/mooc-rr/blob/master/module4/ex4.ipynb) | de98852947736bd9e2f70971a6ed56d0 |
| R        |            4.0.0 | ggplot2 3.3.0                                                 | RStudio | Manjaro Linux                  | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/55066b9debf86be253468bbb91c0a965/mooc-rr/blob/master/module4/challenger.Rmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/55066b9debf86be253468bbb91c0a965/mooc-rr/blob/master/module4/challenger.pdf) | 55066b9debf86be253468bbb91c0a965 |                                                                                                                                                                                   
| R        |            4.0.0 | ggplot2_3.3.1                                                 | RStudio | Windows 10 x64 (build 18363)   |Identical                                 | Identical                                 | Identical                    | Identical | Identical    | 88d1c655b790d6dc02a9352a7e3c81c45720f715 | Tegegne (Note I edited the data then it works)
| Python   |            3.6.4 | statsmodels 0.9.0 numpy 1.13.3 pandas 0.22.0 matplotlib 2.2.2 seaborn 0.8.1 | Jupyter |  Windows 10 Pro 1809 - 64 bits | Identical                                | Identical                                 | Identical                    | Identical | Similar    | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/724aaab995271739bac044894b5182b9/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb) |  724aaab995271739bac044894b5182b9 | 
| Python   |            3.7.4 | numpy 1.19.0 scipy 1.5.0 statsmodels 0.10.1                   | Jupyter | Windows 10 x64 18362.900       | Identical                                | Identical                                 | Identical                    | Identical | Identical   | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/2c1cfe3b7099fc1c57ee95d52ee21f93/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb) |   2c1cfe3b7099fc1c57ee95d52ee21f93 |
| Python   |            3.6.4 | numpy 1.15.0 pandas 0.22.0 seaborn 0.8.1 matplotlib 2.2.3  statsmodels 0.9.0 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical                 | Identical                                 | Identical                    | Identical | Similar     | [ipynb](https://app-learninglab.inria.fr/moocrr/jupyter/user/b4d31d1037af989f9880e6ac666123c2/notebooks/work/module4/exercice_module5.ipynb), [pdf](https://app-learninglab.inria.fr/moocrr/jupyter/user/b4d31d1037af989f9880e6ac666123c2/notebooks/work/module4/exercice_module5.pdf) | b4d31d1037af989f9880e6ac666123c2 |
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 seaborn 0.8.1 statsmodels 0.9.0  | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical                 | Identical                                 | Identical                    | Identical | Identical   | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/26ab366f4d50047285d9a557b01018bd/mooc-rr/blob/master/module4/Analyse%20Challenger.ipynb) | 26ab366f4d50047285d9a557b01018bd |
| Python   |            3.7.3 | statsmodels 0.12.0 numpy 1.16.4 pandas 0.25.0 matplotlib 3.1.1 seaborn 0.9.0 | Jupyter |  Windows 7 6.1.7601 - 64 bits | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/a6a8e0f601822270ca754f29f77749b6/mooc-rr/blob/master/module4/challenger.ipynb) |  a6a8e0f601822270ca754f29f77749b6 | 
| Python   |            3.7.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 seaborn 0.8.1 statsmodels 0.9.0  | Jupyter |  Windows 10 x64 (build 17134) | Identical    
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 scipy 1.1.0 seaborn 0.8.1 statsmodels 0.9.0 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical | Identical | Identical | Identical | Identical | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/82e5a278bec86aaf9c3baaadd03ac681/mooc-rr/blob/master/module4/challenger_Windows_TMalou.ipynb) |  a6a8e0f601822270ca754f29f77749b6 | 
| R        |            4.0.3 | ggplot2_3.3.3                                                 | RStudio | Windows 10 x64 (build 19041)   | Identical                                | Identical                                 | Identical                    | Identical | Identical   | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/813ebc94a0e1e9bad5e0398b9c5c31c1/mooc-rr/blob/master/module4/Replication__regression_haas.Rmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/813ebc94a0e1e9bad5e0398b9c5c31c1/mooc-rr/blob/master/module4/Replication__regression_haas.pdf) | 813ebc94a0e1e9bad5e0398b9c5c31c1 |
| R        |            4.0.3 | ggplot2_3.3.2                                                 | RStudio | Windows 7 x64 (build 7601)     | Identical                  |Identical                                  | Identical                    | Identical | Identical   |[Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/42229b8d9233ebe04805dfd660381627/mooc-rr/blob/master/module4/ChallengerRepro.Rmd), [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/42229b8d9233ebe04805dfd660381627/mooc-rr/tree/master/module4/ChallengerRepro.pdf)|42229b8d9233ebe04805dfd660381627|
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 scipy 1.1.0 seaborn 0.8.1 statsmodels 0.9.0 | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical      | Identical                                 | Identical                    | Identical | Identical   | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/720d0853c18a70320e63c05851c89be9/mooc-rr/blob/c3bff91e8a51f8eb1706123aad9c1e0d0806ad8f/module4/challenger.ipynb) |  720d0853c18a70320e63c05851c89be9 | 
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 statsmodel 0.9.0  | Jupyter | Linux Ubuntu 4.4.0-164-generic | Identical               | Identical                                 | Identical                    | Identical | Identical   |  [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/c0effb0c6dcf58f313629e385bf91920/mooc-rr/blob/master/module4/challenger.ipynb) |  c0effb0c6dcf58f313629e385bf91920 | 
| Python   |            3.8.8 | matplotlib 3.3.4 numpy 1.19.1 pandas 1.2.3 statsmodel 0.12.2 seaborn 0.11.1 | Orgmode | MacOS BigSur 11.2.1 | Identical               | Identical                                 | Identical                    | Identical | Identical   |  [org](https://app-learninglab.inria.fr/moocrr/gitlab/c4aa83a2eb0510a399feb4e7c1611960/mooc-rr/blob/master/module4/exo1_python_fr.org) |  c4aa83a2eb0510a399feb4e7c1611960 | 
| Python   |            3.9.0 | matplotlib 3.3.4 numpy 1.20.1 pandas 1.2.3 statsmodels 0.12.2 seaborn 0.11.1 | Jupyter | Linux Ubuntu 5.8.0-44-generic | $\hat{\alpha}=5.0850$ $\hat{\beta}=-0.1156$ | Identical  | Identical | Identical | problems with the plots | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/678362a9c2b5d46a6a161a762a6e18e0/mooc-rr/blob/master/module4/repro.ipynb) | 678362a9c2b5d46a6a161a762a6e18e0 |
|R         |            4.0.3 | ggplot2_3.3.3                                                 |RStudio  |Windows 10 x64 (build 18362)   |Similar                                    |Similar                                   | Identical                      |Identical |Identical     |[PDF](https://app-learninglab.inria.fr/moocrr/gitlab/0e57e1b8e1a23d7aaeee34c5821213f6/mooc-rr/blob/master/module4/src_R_challenger_VFC.pdf)|1174e0f05f745ff7cf7cd4efeeedce0369a1d57c|
| R        |            4.0.4 | ggplot2_3.3.3                                                 | RStudio | Windows 10 x64 (build 19042.867) |                                        |                                   |                                       |         |             |                      | 2003cd7fa4edd13b96010441bce122a |
| R        |            4.1.0 | ggplot2_3.3.3                                                 | Rstudio |Windows 10 x64 (build 19041)      | Identical                              | Identical                                 | Identical                     |Identical |  Identical   | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/ea4f5ba1b97cd5a14653d4641234245a/mooc-rr/blob/master/module4/exo5_fr_Replication.Rmd), [PDF](https://app-learninglab.inria.fr/moocrr/gitlab/ea4f5ba1b97cd5a14653d4641234245a/mooc-rr/blob/master/module4/exo5_fr_Replication.pdf)                                                                                                                                                                                          | ea4f5ba1b97cd5a14653d4641234245a |
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 statsmodel 0.9.0 seaborn 0.8.1 | Jupyter | Windows 10 x64 (build 19042) | Identical               | Identical                                 | Identical                    | Very slightly changed | Slightly shifted upwards at low temperature   |  [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/7eba932125d7468e05c00632ef18215f/mooc-rr/blob/master/module4/src_Python3_challenger__1_-Copy1.ipynb) |  7eba932125d7468e05c00632ef18215f | 
| R        |            3.6.1 | ggplot2_3.1.1                                                  | Rstudio |Windows >= 8 x64 (build 9200)   |               Identical                    |      Identical                                    |                         Identical     |               Identical         |                             Identical                      |[Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/36cf6267d1f8856c85d87f0f287ea039/mooc-rr/blob/master/module4/EXO1.Rmd) [Pdf](https://app-learninglab.inria.fr/moocrr/gitlab/36cf6267d1f8856c85d87f0f287ea039/mooc-rr/blob/master/module4/test.pdf) |    36cf6267d1f8856c85d87f0f287ea039 |            
| Python   |            3.6.4 | matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 statsmodel 0.9.0 seaborn 0.8.1 | Jupyter | Linux Ubuntu SMP Fri Sep 13 12:02:50 UTC 2019 | Identical | Identical | Identical | Similar | Similar | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/2207ee6c4b0763c29ab8f98156e3343c/mooc-rr/blob/master/module4/Module4-exercice1.ipynb) | @2207ee6c4b0763c29ab8f98156e3343c
| Python   |            3.6.5 | matplotlib 3.1.1 numpy 1.19.1 pandas 1.0.3 statsmodel 0.12.2 seaborn 0.9.0 | Jupyter | MacOS Catalina 10.15.7 | Identical | Identical | Identical | Similar | Similar | [pdf](module4/Module4-exercice1.pdf) | @2207ee6c4b0763c29ab8f98156e3343c
| Python   |            3.8.11 | matplotlib 3.4.2 numpy 1.20.3 pandas 1.3.3 statsmodel 0.12.2 seaborn 0.11.2 | Jupyter | Windows 10.0.17763 -64 bits | Identical | Identical | Identical | Identical after changes of codes | Similar (display only the center) | [pdf](https://app-learninglab.inria.fr/moocrr/jupyter/user/96941f17518054310dda274f17ef8e5e/files/work/module4/exercice1/src_Python3_challenger.pdf) | 96941f17518054310dda274f17ef8e5e
| R        |            4.1.1 | ggplot2_3.3.5                                                  | Rstudio | Windows 10 x64 (build 19041) | Identical | Identical | Identical | Identical | Identical | [rmd](https://app-learninglab.inria.fr/moocrr/gitlab/beace5fe7f3c6c8784a751ead7abeb67/mooc-rr/blob/master/module4/exo.rmd) [html](https://app-learninglab.inria.fr/moocrr/gitlab/beace5fe7f3c6c8784a751ead7abeb67/mooc-rr/blob/master/module4/exo.html) | beace5fe7f3c6c8784a751ead7abeb67
| Python   |            3.6.4 | matplotlib 2.2.3 statsmodels 0.9.0 numpy 1.15.2 pandas 0.22.0 seaborn 0.8.1 | Jupyter | Windows 10.0.19043 N/A build 19043 x64 | Identical | Identical | Identical | Similar | Similar | [ipynd](https://app-learninglab.inria.fr/moocrr/jupyter/user/f039ad8f2e156339cf3f3470f4c914b1/notebooks/work/module4/src_Python3_challenger.ipynb) | f039ad8f2e156339cf3f3470f4c914b1 | 
| R        |            4.0.3 | ggplot2_3.3.2                                                  | Rstudio | Windows 10 x64 (build 19043) | Identical | Identical | Identical | Identical | Identical | [rmd](https://app-learninglab.inria.fr/moocrr/gitlab/a1f9c33f2a123dfe3db955fbc8171db4/mooc-rr/blob/master/module4/exo.rmd) [html](https://app-learninglab.inria.fr/moocrr/gitlab/a1f9c33f2a123dfe3db955fbc8171db4/mooc-rr/blob/master/module4/exo.html) | a1f9c33f2a123dfe3db955fbc8171db4
| R        |            4.1.2 | ggplot2_3.3.5                                                  | Rstudio | Windows 10 x64 (build 19043) | Identical | Identical | Identical | Identical | Identical | [rmd](https://app-learninglab.inria.fr/moocrr/gitlab/23f4754674d3575f868479865ddf701f/mooc-rr/blob/master/module4/MonAnalyse.Rmd) [html](https://app-learninglab.inria.fr/moocrr/gitlab/23f4754674d3575f868479865ddf701f/mooc-rr/blob/master/module4/MonAnalyse.html) | 23f4754674d3575f868479865ddf701f
| Python   |            3.7.11 | matplotlib 3.4.2 statsmodels 0.12.2 numpy 1.20.3 pandas 1.3.2 seaborn 0.11.2 | Jupyter | Windows 10.0.19041  | Identical | Identical | Identical | Identical | Identical | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/2b626fffb391486fd04ef34b8ac9fc42/mooc-rr/blob/e9dca95f1bea8572712c81717f218c611458787d/module4/src_Python3_challenger.ipynb) | @https://app-learninglab.inria.fr/moocrr/gitlab/2b626fffb391486fd04ef34b8ac9fc42 | 
| R        |            3.6.3 | ggplot2_3.3.5                                                  | Rstudio | MacOS 10.12.6 | Identical | Identical | Identical | Identical | Identical | [html](https://app-learninglab.inria.fr/moocrr/gitlab/33deaff202287a50a0e0f4ffa2cb0240/mooc-rr/blob/460360710d68625b0ec8946caa1d91abadf31da1/module4/mod4_exo1_challenger.html) | 33deaff202287a50a0e0f4ffa2cb0240 |
| Python        |            3.10.2 | statsmodel 0.13.1 matplotlib 3.5.1 numpy 1.22.2 pandas 1.4.1                                                 | org-mode | Arch-Linux | Identical | Identical | Identical | similar (not same style) | Identical | [org](https://app-learninglab.inria.fr/moocrr/gitlab/49d86b4b3e98f552beab7f2514d218f6/mooc-rr/blob/master/src_Python3_challenger_Python_org_TM.org) [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/49d86b4b3e98f552beab7f2514d218f6/mooc-rr/blob/master/src_Python3_challenger_Python_org_TM.pdf) | 49d86b4b3e98f552beab7f2514d218f6 |
| R        |            4.1.2 | ggplot2_3.3.5                                                  | Rstudio | Windows 10 x64 (build 19043) | Identical | Identical | Identical | Identical | Identical | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/b0405a09a27327d6e3545e5f2dda1080/mooc-rr/blob/master/module4/src_R_challenger.Rmd) [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/b0405a09a27327d6e3545e5f2dda1080/mooc-rr/blob/master/module4/src_R_challenger.pdf) | b0405a09a27327d6e3545e5f2dda1080 |
| Python   |            3.10.4 | matplotlib 3.6.2 numpy 1.23.4 pandas 1.5.1 statsmodel 0.13.5 seaborn 0.12.1 | Jupyter | Windows 10.0.19044 -64 bits | Identical | Identical | Identical | similar (only shows the centre, one curve is missing) | Identical  | [ipynd](https://app-learninglab.inria.fr/moocrr/gitlab/cd14a147b0da33832541d809c98985f6/mooc-rr/blob/master/module4/challenger_src.ipynb) | cd14a147b0da33832541d809c98985f6
| R        | 4.2.2                  | ggplot2_3.4.2                                                                           | Rstudio            | Windows 10 -64 bits                           | Identical                                                 | Identical                                                            | Identical                       | Identical                                             | Identical                                   | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/feb2301522924f68234e7a552680f397/mooc-rr/blob/master/module4/src_R_challenger.Rmd)                                                                                                                                                                                                                                                                   | feb2301522924f68234e7a552680f397                                                 |
| R        |            4.3.0 | ggplot2_3.4.2                                                 | RStudio | Windows 10 Professionnel Version 21H2 build 19044.2846    | Identical                                | Identical                                 | Identical                    | Identical | Identical    | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/99e00f0a4b6f09cd7f5dcbddefe4902f/mooc-rr/blob/master/module4/src_R_challenger.Rmd)| 99e00f0a4b6f09cd7f5dcbddefe4902f  |
|R         |4.3.0             | base R                                                        |RStudio  | Windows 10 x64 (build 19045) | Identical                                   | Identical                                 | Identical                   | Similar | Similar | [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/37f7e9fa9cf3492510b33122d39127ec/mooc-rr/blob/master/module4/challenger.Rmd) | 37f7e9fa9cf3492510b33122d39127ec |
|Python|3.6.4|matplotlib 2.2.3 numpy 01.15.2 pandas 0.22.0| Jupyter | Linux Ubuntu 4.4.0-164-generic version #192 |Identical|Identical|Identical|Identical|Identical|https://app-learninglab.inria.fr/moocrr/gitlab/28ec0a2489fc7a079d6e157047520de2/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb |28ec0a2489fc7a079d6e157047520de2
|Python|3.8.5|matplotlib 3.5.3 numpy 1.21.5 pandas 1.4.1 statsmodels 0.13.2 seaborn 0.12.1| Jupyter| Windows 10 x64|Identical|Identical|Identical|Identical|Left part of the curve is missing as no point are there|https://app-learninglab.inria.fr/moocrr/gitlab/fa1052534de67443895c02b7c64a08b6/mooc-rr/blob/master/module4/Python3_reproductibility_Enzo_Terreau.ipynb|fa1052534de67443895c02b7c64a08b6|
|Python|3.9.17|matplotlib 3.6.2 numpy 1.23.5 pandas 1.5.2 statsmodels 0.14.0 seaborn 0.12.2| Jupyter|MacOS Darwin Kernel Version 21.0.1 arm64| Identical |Identical | Identical | Identical after (small) changes on the logmodel code | Did not succeed (left part of curve is missing) |https://app-learninglab.inria.fr/moocrr/gitlab/e5e62e6e8091e12ec477af239ac0a4fc/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb| e5e62e6e8091e12ec477af239ac0a4fc|
|Python|3.6.4|matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 seaborn 0.8.1| Jupyter | Ubuntu 4.4.0-164-generic | Similar | Identical | Identical | Identical | Similar | [ipynb] (https://app-learninglab.inria.fr/moocrr/jupyter/user/1487a4f5ffdbe6236ca67c88a1179ffc/notebooks/work/src_Python3_challenger.ipynb) | 1487a4f5ffdbe6236ca67c88a1179ffc|
|Python|3.9.12|matplotlib 3.5.1 numpy 1.22.4 pandas 1.4.3 seaborn 0.11.2| Jupyter | Ubuntu 5.15.0-83-generic | Similar | Identical | Identical | Identical | Similar | [ipynb] (https://app-learninglab.inria.fr/moocrr/gitlab/1f2b5799c7e6329c0238867cf93010b4/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb) | 1f2b5799c7e6329c0238867cf93010b4|
|Python|3.6.4|matplotlib 2.2.3 numpy 1.15.2 pandas 0.22.0 seaborn 0.8.1| Jupyter | Ubuntu 4.4.0-164-generic | Similar | Identical | Identical | Identical | Similar | [ipynb](https://app-learninglab.inria.fr/moocrr/jupyter/user/a081bc04ce9fbc7d062648cfa919b204/notebooks/work/module4/src_Python3_challenger.ipynb) | a081bc04ce9fbc7d062648cfa919b204|
|Python|3.8.13|matplotlib 3.6.2 numpy 1.23.4 pandas 1.5.1 seaborn 0.12.1| Jupyter | Ubuntu 5.15.0-91-generic | Non functional | Non functional | Non functional | Non functional | no extrapolation (earlier errors) | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/fac8f4cc02bfb4e3dfb02802cea5d62a/mooc-rr/blob/master/module4/src_Python3_challenger_Python_ipynb.ipynb) | fac8f4cc02bfb4e3dfb02802cea5d62a |
|Python|3.12.1|matplotlib 3.8.2 numpy 1.26.3 pandas 2.2.0 seaborn 0.13.1| Jupyter | Ubuntu 5.15.0-91-generic | Non functional | Non functional | Non functional | Non functional | no extrapolation (earlier errors) | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/fac8f4cc02bfb4e3dfb02802cea5d62a/mooc-rr/blob/master/module4/src_Python3_challenger_mooc_environment.ipynb) | fac8f4cc02bfb4e3dfb02802cea5d62a |
| Python   |            7.12.0| statsmodels 0.9.0 numpy 1.15.2 pandas 0.22.0 matplotlib 2.2.3 seaborn 0.8.1 | Jupyter | Linux Ubuntu 4.15.0-142-generic | Identical                                | Identical                                 | Identical                    | Identical | Similar      | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/db4d42e543ac9826803271b6e416a5b1/mooc-rr/blob/master/module3/moocrr-reproducibility-study.ipynb), [pdf](https://app-learninglab.inria.fr/moocrr/jupyter/user/db4d42e543ac9826803271b6e416a5b1/files/work/module3/moocrr-reproducibility-study.pdf)                                                                                                                                                                                                                                                                 | db4d42e543ac9826803271b6e416a5b1 |
| R    |4.3.1 |ggplot2_3.4.4| Rstudio| Windows 10 x64 (build 19045)| Identical | Identical | Identical | Identical | Identical | [pdf](https://app-learninglab.inria.fr/moocrr/gitlab/fb956b622f9b38d1f8fb7e50d2d9a54a/mooc-rr/blob/master/module4/src_R_challenger.pdf)|@fb956b622f9b38d1f8fb7e50d2d9a54a|
| Python   |            3.10.4| statsmodels 0.14.0 numpy 1.22.4 pandas 1.4.2 matplotlib 3.7.2 seaborn 0.13.2 | Jupyter | Linux Ubuntu 5.15.0-33-generic | Identical                                | Identical                                 | Identical                    | Similar | Similar      | [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/e357093c53bd5903b5ce129c36733f78/mooc-rr/blob/master/module4/chalenger.ipynb), [html](https://app-learninglab.inria.fr/moocrr/gitlab/e357093c53bd5903b5ce129c36733f78/mooc-rr/blob/master/module4/chalenger.html)  | e357093c53bd5903b5ce129c36733f78 |
|Python|3.7.16|statsmodel 0.13.5 numpy 1.21.5 pandas 1.3.5 matplotlib 3.5.3 seaborn 0.12.2|Jupyter|Windows 10 x64 (build 19045)|Identical|Identical|Identical|Identical|Identical|[html](https://app-learninglab.inria.fr/moocrr/gitlab/d7227cde42eb97d8aac791d907b6bbae/mooc-rr/blob/master/module4/src_Python3_challenger.html), [ipynb](https://app-learninglab.inria.fr/moocrr/gitlab/d7227cde42eb97d8aac791d907b6bbae/mooc-rr/blob/master/module4/src_Python3_challenger.ipynb)|@d7227cde42eb97d8aac791d907b6bbae
|R|4.2.2|ggplot2 3.5.1|RStudio|Windows 10 x64 (build 19045)|Similar|Identical|Identical|Identical|Identical|[pdf](https://app-learninglab.inria.fr/moocrr/gitlab/d7227cde42eb97d8aac791d907b6bbae/mooc-rr/blob/master/module4/src_R_challenger.pdf), [Rmd](https://app-learninglab.inria.fr/moocrr/gitlab/d7227cde42eb97d8aac791d907b6bbae/mooc-rr/blob/master/module4/src_R_challenger.Rmd)|@d7227cde42eb97d8aac791d907b6bbae
|Python|3.6.4|statsmodel 0.9.0 numpy 1.15.2 pandas 0.22.0 matplotlib 2.2.3 seaborn 0.8.1|Jupyter|Windows 10 x64|Identical|Identical|Identical|Identical|Identical|[pdf](https://app-learninglab.inria.fr/moocrr/jupyter/user/3f624f2cce5b76d09dcee501242941ad/nbconvert/pdf/work/module4/src_Python3_challenger.ipynb?download=true)|3f624f2cce5b76d09dcee501242941ad
|R     | 4.2.1|devtools 2.4.5 ggplot2 3.5.1 usethis 3.0.0 | RStudio | macOS Ventura 13.6.7 | Identical | Identical | Identical | Identical | Identical | [RMD](https://app-learninglab.inria.fr/moocrr/gitlab/2f72555a2613970ebb90637b2e23f177/mooc-rr/blob/master/module4/exercices_module4_1.Rmd) | 2f72555a2613970ebb90637b2e23f177 |
|Python|3.9.15|statsmodel 0.14.0 numpy 1.26.5 pandas 2.1.4 matplotlib 3.8.2 seaborn 0.13.0|Jupyter|Windows 10 x64|Identical|Identical|Identical|Identical|Identical|[notebook](https://app-learninglab.inria.fr/moocrr/gitlab/cbf89fc6bd203f862a5d1c0cdec12d94/mooc-rr/blob/master/module4/MOOC_challenger.ipynb)|cbf89fc6bd203f862a5d1c0cdec12d94 
|R  | 4.5.0 | ggplot2 3.5.2 readr 2.1.5 | RStudio | Windows | Identical | Identical | Identical | Identical | Identical | [RMD](https://app-learninglab.inria.fr/moocrr/gitlab/433835ee939dd34ba5afd7c0a68da139/mooc-rr/blob/master/module4/module4_exo1.Rmd) | 433835ee939dd34ba5afd7c0a68da139|
|R   | 4.5.0| ggplot2 3.5.2 readr 2.1.5 | RStudio | Windows 11 | Identical | Identical | Identical | Identical | Identical| https://app-learninglab.inria.fr/moocrr/gitlab/moocrr-session3/moocrr-reproducibility-study 